<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Subdomain Restrictions
    |--------------------------------------------------------------------------
    |
    | This configuration contains restricted words that cannot be used as tenant
    | subdomains, including common TLDs, Laravel folder/route names, and PHP
    | reserved terms.
    |
    */

    'subdomains' => [
        // Common TLDs and web terms
        'www',
        'com',
        'org',
        'net',
        'edu',
        'gov',
        'io',
        'co',
        'app',
        'whatsmark',

        // Laravel folder and route names
        'app',
        'bootstrap',
        'config',
        'database',
        'public',
        'resources',
        'routes',
        'storage',
        'tests',
        'vendor',
        'artisan',
        'api',
        'admin',
        'assets',
        'auth',
        'css',
        'js',
        'images',
        'login',
        'logout',
        'register',
        'password',
        'webhook',

        // Laravel common route names
        'home',
        'dashboard',
        'profile',
        'settings',
        'tenant',

        // PHP reserved words
        'abstract',
        'and',
        'array',
        'as',
        'break',
        'callable',
        'case',
        'catch',
        'class',
        'clone',
        'const',
        'continue',
        'declare',
        'default',
        'die',
        'do',
        'echo',
        'else',
        'elseif',
        'empty',
        'enddeclare',
        'endfor',
        'endforeach',
        'endif',
        'endswitch',
        'endwhile',
        'eval',
        'exit',
        'extends',
        'final',
        'finally',
        'fn',
        'for',
        'foreach',
        'function',
        'global',
        'goto',
        'if',
        'implements',
        'include',
        'include_once',
        'instanceof',
        'insteadof',
        'interface',
        'isset',
        'list',
        'namespace',
        'new',
        'or',
        'print',
        'private',
        'protected',
        'public',
        'require',
        'require_once',
        'return',
        'static',
        'switch',
        'throw',
        'trait',
        'try',
        'unset',
        'use',
        'var',
        'while',
        'xor',
        'yield',
    ],
];
